/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.client;

import com.ibm.hsc.cim.client.CuodActions;
import com.ibm.hsc.cim.client.HSCCIMClient;
import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.client.HSCCECClient;
import com.ibm.hsc.client.HSCClientObjectFactory;
import com.ibm.hsc.client.HSCFrameClient;
import com.ibm.hsc.client.HSCLPARClient;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.HSCException;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscPasswordMgr;
import com.ibm.hsc.common.util.HscUtil;
import com.ibm.hsc.common.util.PparInfoPacker;
import com.ibm.websm.diagnostics.IDebug;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMClient;

public class HSCCECCIMClient
extends HSCCIMClient
implements HSCCECClient {
    private static final String KEY_SEP = "###";
    private static final String PARTITION_NAME_SEP = "*";
    private static final short INVALID_DRC_NDX_VALUE = 0;
    protected static final String MOF_AFFINITY_CAPABILITY = "AffinityCapability";
    protected static final String MOF_CAGE_NUMBER = "CageNumber";
    protected static final String MOF_CEC_CAPABILITY = "Capability";
    protected static final String MOF_CUOD_CAPABILITIES = "CUoDCapabilities";
    protected static final String MOF_CSP_SURVEILLANCE_POLICY = "CspSurveillancePolicy";
    protected static final String MOF_CSP_VERSION = "CspVersion";
    protected static final String MOF_LMB_SIZE = "LMBSize";
    protected static final String MOF_MODE = "Mode";
    protected static final String MOF_MODEL = "Model";
    protected static final String MOF_OP_PANEL_VALUE = "OpPanelValue";
    protected static final String MOF_POWER_OFF_POLICY = "PowerOffPolicy";
    protected static final String MOF_RUNTIME_CAPABILITY = "RuntimeCapability";
    protected static final String MOF_SERIAL_NUMBER = "SerialNumber";
    protected static final String MOF_CLASS_CODE_INFO = "ClassCodeInfo";
    protected static final String MOF_DRAWER_IDS = "DrawerIDs";
    protected static final String MOF_DRC_INDEX = "DRCIndex";
    protected static final String MOF_ERROR_STATE = "12";
    protected static final String MOF_IO_DRAWER_DEVICE_ID = "IODrawerDeviceID";
    protected static final String MOF_IO_RECOVER = "ioRecover";
    protected static final String MOF_NOT_READY_STATE = "13";
    protected static final String MOF_PARTITION_STATE = "PartitionState";
    protected static final String MOF_PCI_BUS = "PCIBus";
    protected static final String MOF_PHYSICAL_LOCATION = "SlotLocation";
    protected static final String MOF_READY_STATE = "1";
    protected static final String MOF_RUNNING_STATE = "8";
    protected static final String MOF_SLOT_ID = "SlotID";
    protected static final String MOF_SLOT_IDS = "SlotIDs";
    protected static final String MOF_SLOT_LOCATION = "SlotLocation";
    protected static final String MOF_STATE = "State";
    protected static final String MOF_STOPPED_STATE = "7";
    protected static final String MOF_UNAVAILABLE_STATE = "252";
    protected static final String MOF_SMA_PHY_LOC_CODE = "PhysicalLocation";
    protected static final String MOF_SMA_NETWORK_ID = "NetworkNumber";
    protected static final String MOF_SMA_WINDOW_NUM = "NumOfWindowsSupported";
    protected static final String MOF_GET_SNI_PAIR_INFO = "GetSNIPairInfo";
    protected static final String MOF_GET_SNI_LOGICAL_ID = "GetSNILogicalID";
    protected static final String MOF_ALLOCATED_CPU = "allocatedCPU";
    protected static final String MOF_CPU_ID = "DeviceID";
    protected static final String MOF_CPU_RECOVER = "cpuRecover";
    protected static final String MOF_CPU_STATUS = "CPUstatus";
    protected static final String MOF_GET_DLPAR_CPU_INFO = "getDLPARCPUInfo";
    protected static final String MOF_INSTALLED_CPU_COUNT = "InstalledCPUCount";
    protected static final String MOF_MAXIMUM_CPU = "maximumCPU";
    protected static final String MOF_MINIMUM_CPU = "minimumCPU";
    protected static final String MOF_PROCESSOR_IDS = "ProcessorIDs";
    protected static final String MOF_RUNNING_LPAR_MASK = "runningLPARMask";
    protected static final String MOF_STOPPED_CPU = "stopped";
    protected static final String MOF_ALLOCATED_MEM = "allocatedMem";
    protected static final String MOF_ALLOCATED_MEMORY = "AllocatedMemory";
    protected static final String MOF_GET_DLPAR_MEM_INFO = "getDLPARMemInfo";
    protected static final String MOF_INSTALLED_MEMORY = "InstalledMemory";
    protected static final String MOF_MAXIMUM_MEM = "maximumMem";
    protected static final String MOF_MEM_RECOVER = "memRecover";
    protected static final String MOF_MINIMUM_MEM = "minimumMem";
    protected static final String MOF_PAGE_TABLE_MEMORY = "PageTableMemory";
    protected static final String MOF_PARTITION_IDS = "partitionIDs";
    protected static final String MOF_PARTITION_NAMES = "PartitionNames";
    protected static final String MOF_PARTITION_NAMES_INT = "Name";
    protected static final String MOF_PARTITION_NAMES_USER = "UserDefinedName";
    protected static final String MOF_LPAR_SLOT_ID = "LPARSlotID";
    protected static final String MOF_GET_LIST_LED = "GetLEDTypeList";
    protected static final String MOF_GET_STATE_LED = "GetLEDState";
    protected static final String MOF_INDEX_LED = "index";
    protected static final String MOF_LED_TYPE = "LEDType";
    protected static final String MOF_SET_LED = "SetLED";
    protected static final String MOF_SETTING_LED = "setting";
    protected static final String MOF_SUPPORTED_LED = "IsLEDTypeSupported";
    public static final String SYSTEM_ATTENTION_LED = "1";
    public static final String IDENTIFY_LED = "2";
    public static final int SUPPORTS_LED = 1;
    public static final String CSP_BUSY_EXCEPTION_ID = "3002";
    public CuodActions cuodActionHandler;

    public static HSCCECCIMClient createInstance(String string, String string2, boolean bl) throws HSCException {
        boolean bl2 = false;
        String string3 = null;
        String string4 = null;
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            Enumeration enumeration = HscUtil.getCIMEnumInstances(string, cIMObjectPath, true);
            CIMObjectPath cIMObjectPath2 = null;
            CIMObjectPath cIMObjectPath3 = null;
            String string5 = null;
            while (enumeration != null && enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath4 = (CIMObjectPath)enumeration.nextElement();
                CIMValue cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath4, MOF_PARTITION_NAMES_INT);
                string5 = (String)cIMValue.getValue();
                if (string2.equals(string5)) {
                    cIMObjectPath3 = cIMObjectPath4;
                    if (bl) break;
                }
                if (bl || !string2.equals((String)(cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath4, MOF_PARTITION_NAMES_USER)).getValue())) continue;
                if (bl2) {
                    string3 = "There are more than one managed systems with the same user defined name. Please specify the managed system in the form of mmmm*ssss where mmmm is machine type, and ssss is the serial number and retry the command.";
                    string4 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "MATCHING_USER_DEFINED_CEC_NAMES", string3, null);
                    throw new HSCException(string4);
                }
                bl2 = true;
                cIMObjectPath2 = cIMObjectPath4;
            }
            if (cIMObjectPath2 == null && cIMObjectPath3 == null) {
                return null;
            }
            if (cIMObjectPath2 == null) {
                string5 = string2;
            } else {
                cIMObjectPath3 = cIMObjectPath2;
            }
            return new HSCCECCIMClient(string, string5, cIMObjectPath3);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public HSCCECCIMClient(String string, String string2, CIMObjectPath cIMObjectPath) {
        super(string, null, string2, cIMObjectPath);
        CIMValue cIMValue;
        try {
            cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath, MOF_PARTITION_NAMES_INT);
            this.mIntName = (String)cIMValue.getValue();
        }
        catch (CIMException cIMException) {
            // empty catch block
        }
        try {
            cIMValue = HscUtil.getCIMAttribute(string, cIMObjectPath, MOF_PARTITION_NAMES_USER);
            this.mUserDefinedName = (String)cIMValue.getValue();
        }
        catch (CIMException cIMException) {}
    }

    public void changeSystem(Hashtable hashtable) throws HSCException {
        CIMInstance cIMInstance = null;
        Enumeration enumeration = null;
        Integer n = null;
        Object var5_5 = null;
        String string = null;
        try {
            cIMInstance = HscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                var5_5 = hashtable.get(string);
                if (string.equals(MOF_PARTITION_NAMES_USER)) {
                    cIMInstance.setProperty(string, new CIMValue((Object)var5_5));
                }
                if (string.equals(MOF_CSP_SURVEILLANCE_POLICY)) {
                    n = var5_5;
                    cIMInstance.setProperty(string, new CIMValue((Object)new UnsignedInt8(n.shortValue())));
                }
                if (!string.equals(MOF_POWER_OFF_POLICY)) continue;
                cIMInstance.setProperty(string, new CIMValue((Object)var5_5));
            }
            HscUtil.setCIMInstance(this.mHostName, this.mObjectPath, cIMInstance);
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void powerOn(short s, short s2) throws HSCException {
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt8 unsignedInt82 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            unsignedInt8 = new UnsignedInt8(s);
            unsignedInt82 = new UnsignedInt8(s2);
            vector.add(new CIMProperty("BootMode", new CIMValue((Object)unsignedInt8)));
            vector.add(new CIMProperty("PowerOnMode", new CIMValue((Object)unsignedInt82)));
            if (IDebug.enabled()) {
                System.out.println("Calling CIM Method to power on");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PowerOn", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finishd CIM Method to power on");
            }
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public void powerOff() throws HSCException {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            if (IDebug.enabled()) {
                System.out.println("Calling CIM Method to power off");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PowerOff", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finishd CIM Method to power off");
            }
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public void rebuild() throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            vector.add(new CIMProperty("closeType", new CIMValue((Object)new UnsignedInt8(0))));
            if (IDebug.enabled()) {
                System.out.println("Calling CIM Method to rebuild cec");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RebuildCec", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finishd CIM Method to rebuild cec");
            }
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public void reset() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        CIMProperty cIMProperty = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            Enumeration enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_CompSysPartition", "IBMHSC_ComputerSystem", "GroupComponent", "PartComponent", true, false, null);
            string = this.getIntName();
            string2 = "000*" + string;
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_INT);
                string3 = (String)cIMProperty.getValue().getValue();
                if (!string3.equals(string2)) continue;
                cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", cIMInstance.getKeyValuePairs());
                vector.add(new CIMProperty("ResetType", new CIMValue((Object)new UnsignedInt8(2))));
                if (IDebug.enabled()) {
                    System.out.println("Calling CIM Method to reset OS");
                }
                HscUtil.invokeCIMMethod(this.mHostName, cIMObjectPath, "OSReset", vector, vector2);
                if (IDebug.enabled()) {
                    System.out.println("Finished CIM Method to reset OS");
                }
                break;
            }
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public void createPartition(Hashtable hashtable) throws HSCException {
        CIMClass cIMClass = null;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var10_10 = null;
        try {
            string = this.getHostName();
            string3 = (String)hashtable.get(MOF_PARTITION_NAMES_USER);
            string2 = "111*".concat(this.mIntName);
            cIMObjectPath = new CIMObjectPath("IBMHSC_Partition");
            cIMClass = HscUtil.getCIMClass(string, cIMObjectPath, false);
            cIMInstance2 = HscUtil.createNewCIMInstance(cIMClass);
            cIMInstance2.setProperty("CreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance2.setProperty(MOF_PARTITION_NAMES_INT, new CIMValue((Object)string2));
            cIMInstance2.setProperty(MOF_PARTITION_NAMES_USER, new CIMValue((Object)string3));
            cIMInstance2.setProperty("PartitionType", new CIMValue((Object)new UnsignedInt8(1)));
            cIMObjectPath = new CIMObjectPath("IBMHSC_Partition", cIMInstance2.getKeyValuePairs());
            cIMObjectPath.setNameSpace("root/ibmhscV3_2");
            cIMObjectPath = HscUtil.createCIMInstance(string, cIMObjectPath, cIMInstance2);
            cIMInstance2 = HscUtil.getCIMInstance(string, cIMObjectPath, true);
            string2 = (String)cIMInstance2.getProperty(MOF_PARTITION_NAMES_INT).getValue().getValue();
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        catch (Throwable throwable) {
            throw new HSCException(throwable);
        }
        try {
            cIMObjectPath2 = new CIMObjectPath("IBMHSC_LparProfile");
            cIMClass = HscUtil.getCIMClass(string, cIMObjectPath2, false);
            cIMInstance = HscUtil.createNewCIMInstance(cIMClass);
            hashtable.put("PartitionName", string2);
            cIMInstance = this.buildProfileInParams(cIMInstance, hashtable);
            cIMObjectPath2 = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
            cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
            cIMObjectPath2 = HscUtil.createCIMInstance(string, cIMObjectPath2, cIMInstance);
        }
        catch (CIMException cIMException) {
            try {
                HscUtil.deleteCIMInstance(string, cIMObjectPath);
            }
            catch (CIMException cIMException2) {
                throw new HSCException(cIMException2);
            }
            throw new HSCException(cIMException);
        }
        catch (Throwable throwable) {
            try {
                HscUtil.deleteCIMInstance(string, cIMObjectPath);
            }
            catch (CIMException cIMException) {
                throw new HSCException(cIMException);
            }
            throw new HSCException(throwable);
        }
        try {
            this.createDefaultProfileAssociation(cIMObjectPath2, cIMObjectPath);
        }
        catch (CIMException cIMException) {
            try {
                HscUtil.deleteCIMInstance(string, cIMObjectPath);
                HscUtil.deleteCIMInstance(string, cIMObjectPath2);
            }
            catch (CIMException cIMException3) {
                throw new HSCException(cIMException3);
            }
            throw new HSCException(cIMException);
        }
        catch (Throwable throwable) {
            throw new HSCException(throwable);
        }
    }

    public void createAffinityPartition(Hashtable[] hashtableArray, String string) throws HSCException {
        Object var3_3 = null;
        Object var4_4 = null;
        String string2 = null;
        Object var6_6 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector(3);
        Object var9_9 = null;
        Vector vector3 = null;
        try {
            vector.addElement(new CIMProperty("clusterSize", new CIMValue((Object)new UnsignedInt8(string))));
            vector.addElement(new CIMProperty("UpdateFlag", new CIMValue((Object)new UnsignedInt8(0))));
            vector3 = this.getPPARInfo(string, true);
            if (vector3.size() < hashtableArray.length) {
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "ALPAR_ERROR_NOT_ENOUGH_PHYS_LOC");
                throw new HSCException(string2);
            }
            Object var11_11 = null;
            int n = 0;
            while (n < hashtableArray.length) {
                hashtableArray[n].put("PhysicalLocationCode", (String)vector3.get(n));
                ++n;
            }
            vector.addElement(new CIMProperty("partitionInfo", new CIMValue((Object)new PparInfoPacker().packInfo(hashtableArray), new CIMDataType(29))));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "SetupPPAR", vector, new Vector());
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        catch (Exception exception) {
            throw new HSCException(exception);
        }
    }

    public void deletePartition(String string) throws HSCException {
        CIMClient cIMClient = null;
        CIMNameSpace cIMNameSpace = null;
        Object var4_4 = null;
        HSCClientObjectFactory hSCClientObjectFactory = null;
        HSCLPARClient hSCLPARClient = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string2 = this.getIntName();
            string3 = this.getHostName();
            cIMNameSpace = new CIMNameSpace(string3, "root/ibmhscV3_2");
            string4 = HscPasswordMgr.getPassword("hscroot");
            cIMClient = new CIMClient(cIMNameSpace, "hscroot", string4);
        }
        catch (Throwable throwable) {
            throw new HSCException(throwable);
        }
        try {
            hSCClientObjectFactory = HSCClientObjectFactory.getInstance(string3, null);
            hSCLPARClient = hSCClientObjectFactory.createLPARClient(string2, string, false);
            int n = hSCLPARClient.getPartitionState();
            if ((short)n == 9 || (short)n == 6 || (short)n == 8) {
                String string5 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "STATE_PARTITION_CANNOT_BE_DELETED");
                throw new HSCException(string5);
            }
            String string6 = hSCLPARClient.getIntName();
            short s = this.getPartitionSlotId(string6);
            if (s == 0) {
                String string7 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "TYPE_PARTITION_CANNOT_BE_DELETED");
                throw new HSCException(string7);
            }
            cIMClient.deleteInstance(hSCLPARClient.getObjectPath());
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void deleteAffinityPartitions() throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>(1);
        try {
            vector.addElement(new CIMProperty("PPARSlotIDs", new CIMValue((Object)new Integer[0], new CIMDataType(21))));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RemovePPARSetup", vector, new Vector(0));
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void createProfile(Hashtable hashtable) throws HSCException {
        CIMClass cIMClass = null;
        Object var3_3 = null;
        CIMInstance cIMInstance = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMObjectPath cIMObjectPath4 = null;
        CIMObjectPath cIMObjectPath5 = null;
        CIMValue cIMValue = null;
        Enumeration enumeration = null;
        Enumeration enumeration2 = null;
        String string = null;
        Object var17_17 = null;
        String string2 = null;
        Object var19_19 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Object var23_23 = null;
        String string6 = null;
        List list = null;
        List list2 = null;
        Vector<CIMObjectPath> vector = null;
        Vector vector2 = null;
        Vector<CIMInstance> vector3 = new Vector<CIMInstance>();
        try {
            int n;
            string2 = this.getHostName();
            string6 = (String)hashtable.get(MOF_PARTITION_NAMES_USER);
            string = (String)hashtable.get("ActionType");
            list2 = (List)hashtable.get("SysProfProfileList");
            list = (List)hashtable.get("SysProfPartitionList");
            vector = new Vector<CIMObjectPath>();
            vector.setSize(list.size());
            vector2 = new Vector(list2.size());
            vector2.setSize(list2.size());
            enumeration2 = this.getPartitionObjectPathes();
            while (enumeration2 != null && enumeration2.hasMoreElements()) {
                cIMObjectPath4 = (CIMObjectPath)enumeration2.nextElement();
                cIMValue = HscUtil.getCIMAttribute(string2, cIMObjectPath4, MOF_PARTITION_NAMES_USER);
                n = 0;
                while (n < list.size()) {
                    string5 = (String)list.get(n);
                    string3 = (String)cIMValue.getValue();
                    if (string3.equals(string5)) {
                        vector.set(n, cIMObjectPath4);
                    }
                    ++n;
                }
            }
            n = 0;
            int n2 = 0;
            while (n2 < list2.size()) {
                string5 = (String)list2.get(n2);
                cIMObjectPath4 = (CIMObjectPath)vector.get(n2);
                enumeration = HscUtil.getCIMAssociation(string2, cIMObjectPath4, "IBMHSC_PartitionProfile", "IBMHSC_LparProfile", "Element", "Setting");
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                    cIMValue = HscUtil.getCIMAttribute(string2, cIMObjectPath, MOF_PARTITION_NAMES_USER);
                    string4 = (String)cIMValue.getValue();
                    if (!string4.equals(string5)) continue;
                    vector3.add(HscUtil.getCIMInstance(string2, cIMObjectPath, false));
                    n = 1;
                    break;
                }
                ++n2;
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        if (vector3 != null && vector3.size() > 0) {
            try {
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_SystemProfile");
                cIMClass = HscUtil.getCIMClass(string2, cIMObjectPath2, false);
                cIMInstance = HscUtil.createNewCIMInstance(cIMClass);
                cIMInstance.setProperty("name", new CIMValue((Object)"1234"));
                string5 = (String)hashtable.get("ManagedSystem");
                cIMInstance.setProperty("ComputerSystemName", new CIMValue((Object)string5));
                cIMInstance.setProperty("ComputerSystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMInstance.setProperty(MOF_PARTITION_NAMES_USER, new CIMValue((Object)string6));
                cIMObjectPath2 = new CIMObjectPath("IBMHSC_SystemProfile", cIMInstance.getKeyValuePairs());
                cIMObjectPath2.setNameSpace("root/ibmhscV3_2");
                cIMObjectPath3 = HscUtil.createCIMInstance(string2, cIMObjectPath2, cIMInstance);
            }
            catch (CIMException cIMException) {
                throw new HSCException(cIMException);
            }
            try {
                cIMObjectPath5 = cIMObjectPath3;
                cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
                this.createSysProfileAssociations(string2, vector3, cIMObjectPath3);
            }
            catch (CIMException cIMException) {
                try {
                    HscUtil.deleteCIMInstance(string2, cIMObjectPath3);
                }
                catch (CIMException cIMException2) {
                    throw new HSCException(cIMException2);
                }
                throw new HSCException(cIMException);
            }
        }
    }

    public void deleteProfile(String string) throws HSCException {
        block6: {
            CIMClient cIMClient = null;
            CIMNameSpace cIMNameSpace = null;
            CIMObjectPath cIMObjectPath = null;
            CIMValue cIMValue = null;
            Enumeration enumeration = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            boolean bl = false;
            try {
                cIMNameSpace = new CIMNameSpace(this.mHostName, "root/ibmhscV3_2");
                string4 = HscPasswordMgr.getPassword("hscroot");
                cIMClient = new CIMClient(cIMNameSpace, "hscroot", string4);
            }
            catch (Throwable throwable) {
                throw new HSCException(throwable);
            }
            try {
                enumeration = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_CompSysProfile", "IBMHSC_SystemProfile", "Element", "Configuration");
                while (enumeration.hasMoreElements()) {
                    cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                    cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_NAMES_USER);
                    string3 = (String)cIMValue.getValue();
                    if (!string3.equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    cIMClient.deleteInstance(cIMObjectPath);
                    break block6;
                }
                string2 = HSCResourceBundleUtil.getMessage("HSCCommonBundle", "DELETE_PROFILE_NOT_FOUND");
                throw new HSCException(string2);
            }
            catch (CIMException cIMException) {
                throw new HSCException(cIMException);
            }
        }
    }

    public void backUpProfileData(String string) throws HSCException {
        CIMValue cIMValue = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            cIMValue = new CIMValue((Object)new UnsignedInt8(4));
            vector.add(new CIMProperty("RestoreType", cIMValue));
            cIMValue = new CIMValue((Object)string);
            vector.add(new CIMProperty("FileName", cIMValue));
            if (IDebug.enabled()) {
                System.out.println("Starting to invoke CIM to backup NVRAM");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RestoreNVRAM", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finishing invoking CIM to backup NVRAM");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void restoreProfileData(String string, short s) throws HSCException {
        CIMValue cIMValue = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            cIMValue = new CIMValue((Object)new UnsignedInt8(s));
            vector.add(new CIMProperty("RestoreType", cIMValue));
            cIMValue = new CIMValue((Object)string);
            vector.add(new CIMProperty("FileName", cIMValue));
            if (IDebug.enabled()) {
                System.out.println("Starting to invoke CIM to restore NVRAM");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RestoreNVRAM", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finish invoking CIM to restore NVRAM");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void partitionDataRecover(short s) throws HSCException {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        try {
            vector.add(new CIMProperty("compSystem", new CIMValue((Object)this.mObjectPath, new CIMDataType(41))));
            vector.add(new CIMProperty("RecoverType", new CIMValue((Object)new UnsignedInt8(s))));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "PartitionDataRecover", vector, new Vector());
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public void initializeData() throws HSCException {
        CIMValue cIMValue = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector();
        try {
            cIMValue = new CIMValue((Object)new UnsignedInt8(5));
            vector.add(new CIMProperty("RestoreType", cIMValue));
            cIMValue = new CIMValue((Object)" ");
            vector.add(new CIMProperty("FileName", cIMValue));
            if (IDebug.enabled()) {
                System.out.println("Starting to invoke CIM to initialize NVRAM");
            }
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RestoreNVRAM", vector, vector2);
            if (IDebug.enabled()) {
                System.out.println("Finish invoking CIM to initialize NVRAM");
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Hashtable getMoveToParNames(String string, String string2) throws HSCException {
        try {
            Hashtable hashtable = new Hashtable();
            Enumeration enumeration = this.getPartitionObjectPathes();
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            Vector<Short> vector3 = new Vector<Short>();
            while (enumeration.hasMoreElements()) {
                String string3;
                String string4;
                int n;
                CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                CIMValue cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_NAMES_INT);
                String string5 = (String)cIMValue.getValue();
                if (string != null && string5.equals(string) || (n = Integer.parseInt(string4 = (String)(cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, "DLPARCapabilities")).getValue())) != 15 && (!string2.equals("slot") || (n & 4) == 0) || !(string3 = (String)(cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_STATE)).getValue()).equals(MOF_RUNNING_STATE)) continue;
                cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_NAMES_USER);
                String string6 = (String)cIMValue.getValue();
                vector.addElement(string5);
                vector2.addElement(string6);
                vector3.addElement(new Short(this.getPartitionSlotId(string5)));
            }
            if (vector.size() <= 0) {
                return null;
            }
            hashtable.put("intNames", vector);
            hashtable.put("userNames", vector2);
            hashtable.put("parSlotIds", vector3);
            return hashtable;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public Enumeration getPartitionObjectPathes() throws CIMException {
        Enumeration enumeration = null;
        try {
            enumeration = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_CompSysPartition", "IBMHSC_Partition", "GroupComponent", "PartComponent");
        }
        catch (CIMException cIMException) {
            cIMException.printStackTrace();
            throw cIMException;
        }
        return enumeration;
    }

    public Enumeration getIODrawerObjectPathes() throws CIMException {
        return HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_CompSysIODrawer", "IBMHSC_IODrawer", "GroupComponent", "PartComponent");
    }

    public Vector getAllAssignedSlotObjectPathes() throws HSCException {
        try {
            Vector vector = new Vector();
            Enumeration enumeration = this.getPartitionObjectPathes();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                CIMValue cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_STATE);
                String string = (String)cIMValue.getValue();
                if (string.equals("1") || string.equals(MOF_NOT_READY_STATE) || string.equals(MOF_UNAVAILABLE_STATE)) continue;
                Enumeration enumeration2 = HscUtil.getCIMAssociation(this.mHostName, cIMObjectPath, "IBMHSC_AllocatedSlot", "IBMHSC_PCISlot", "GroupComponent", "PartComponent");
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(enumeration2.nextElement());
                }
            }
            return vector;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Vector getAllSlotObjectInstances() throws HSCException {
        try {
            Vector vector = new Vector();
            Enumeration enumeration = this.getIODrawerObjectPathes();
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                Enumeration enumeration2 = HscUtil.getCIMAssociationInst(this.mHostName, cIMObjectPath, "IBMHSC_IODrawerSlot", "IBMHSC_PCISlot", "GroupComponent", "PartComponent", true, false, null);
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(enumeration2.nextElement());
                }
            }
            return vector;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Vector getAllFreeSlotInstances() throws HSCException {
        Vector vector = this.getAllAssignedSlotObjectPathes();
        Vector vector2 = this.getAllSlotObjectInstances();
        int n = 0;
        while (n < vector2.size()) {
            CIMInstance cIMInstance = (CIMInstance)vector2.elementAt(n);
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_PCISlot", cIMInstance.getKeyValuePairs());
            cIMObjectPath.setNameSpace("root/ibmhscV3_2");
            int n2 = 0;
            while (n2 < vector.size()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)vector.elementAt(n2);
                if (cIMObjectPath.equals((Object)cIMObjectPath2)) {
                    vector2.remove(n--);
                    vector.remove(n2);
                    break;
                }
                ++n2;
            }
            ++n;
        }
        return vector2;
    }

    public Hashtable getSystemData() throws HSCException {
        Boolean bl = null;
        CIMInstance cIMInstance = null;
        Object var3_3 = null;
        CIMValue cIMValue = null;
        Object var5_5 = null;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        UnsignedInt8 unsignedInt8 = null;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt32 unsignedInt32 = null;
        String string = null;
        try {
            cIMInstance = HscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            cIMValue = cIMInstance.getProperty(MOF_PARTITION_NAMES_USER).getValue();
            if (cIMValue != null) {
                string = (String)cIMValue.getValue();
                hashtable.put(MOF_PARTITION_NAMES_INT, string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_OP_PANEL_VALUE).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put(MOF_OP_PANEL_VALUE, string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_CSP_VERSION).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put(MOF_CSP_VERSION, string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_MODEL).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put(MOF_MODEL, string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_SERIAL_NUMBER).getValue()) != null) {
                string = (String)cIMValue.getValue();
                hashtable.put(MOF_SERIAL_NUMBER, string);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_AFFINITY_CAPABILITY).getValue()) != null) {
                unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                hashtable.put(MOF_AFFINITY_CAPABILITY, new Integer(unsignedInt8.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_CUOD_CAPABILITIES).getValue()) != null) {
                unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                hashtable.put("CuodCapability", new Integer(unsignedInt16.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_CAGE_NUMBER).getValue()) != null) {
                unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                hashtable.put(MOF_CAGE_NUMBER, new Integer(unsignedInt8.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_CEC_CAPABILITY).getValue()) != null) {
                unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                hashtable.put("CecCapability", new Integer(unsignedInt16.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_CSP_SURVEILLANCE_POLICY).getValue()) != null) {
                unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                hashtable.put(MOF_CSP_SURVEILLANCE_POLICY, new Integer(unsignedInt16.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_LMB_SIZE).getValue()) != null) {
                unsignedInt32 = (UnsignedInt32)cIMValue.getValue();
                hashtable.put("LmbSize", new Integer(unsignedInt32.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_MODE).getValue()) != null) {
                unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                hashtable.put(MOF_MODE, new Integer(unsignedInt8.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_POWER_OFF_POLICY).getValue()) != null) {
                bl = (Boolean)cIMValue.getValue();
                hashtable.put(MOF_POWER_OFF_POLICY, bl);
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_RUNTIME_CAPABILITY).getValue()) != null) {
                unsignedInt16 = (UnsignedInt16)cIMValue.getValue();
                hashtable.put(MOF_RUNTIME_CAPABILITY, new Integer(unsignedInt16.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_STATE).getValue()) != null) {
                unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                hashtable.put(MOF_STATE, new Integer(unsignedInt8.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_INSTALLED_CPU_COUNT).getValue()) != null) {
                unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                hashtable.put(MOF_INSTALLED_CPU_COUNT, new Integer(unsignedInt8.intValue()));
            }
            if ((cIMValue = cIMInstance.getProperty(MOF_INSTALLED_MEMORY).getValue()) != null) {
                unsignedInt32 = (UnsignedInt32)cIMValue.getValue();
                hashtable.put(MOF_INSTALLED_MEMORY, new Integer(unsignedInt32.intValue()));
            }
            return hashtable;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Vector getFreeIOSlotData() throws HSCException {
        CIMInstance cIMInstance;
        Vector vector = this.getAllFreeSlotInstances();
        TreeMap treeMap = new TreeMap();
        int n = 0;
        while (n < vector.size()) {
            cIMInstance = (CIMInstance)vector.elementAt(n);
            this.getSlotData(cIMInstance, treeMap, false);
            ++n;
        }
        cIMInstance = new Vector();
        if (treeMap.size() == 0) {
            return cIMInstance;
        }
        SortedMap sortedMap = treeMap.tailMap(treeMap.firstKey());
        Iterator iterator = sortedMap.keySet().iterator();
        while (iterator.hasNext()) {
            cIMInstance.addElement(sortedMap.get(iterator.next()));
        }
        return cIMInstance;
    }

    public Vector getAllIOData() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        CIMProperty cIMProperty = null;
        Enumeration enumeration = null;
        Hashtable<String, Object> hashtable = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Vector vector = null;
        Vector vector2 = null;
        short s = 0;
        vector2 = this.getAllSlotObjectInstances();
        try {
            vector = new Vector();
            int n = 0;
            while (n < vector2.size()) {
                hashtable = new Hashtable<String, Object>();
                cIMInstance = (CIMInstance)vector2.elementAt(n);
                cIMProperty = cIMInstance.getProperty(MOF_IO_DRAWER_DEVICE_ID);
                string = (String)cIMProperty.getValue().getValue();
                cIMProperty = cIMInstance.getProperty(MOF_SLOT_ID);
                s = ((UnsignedInt8)cIMProperty.getValue().getValue()).shortValue();
                cIMProperty = cIMInstance.getProperty(MOF_CLASS_CODE_INFO);
                string4 = (String)cIMProperty.getValue().getValue();
                cIMProperty = cIMInstance.getProperty("SlotLocation");
                string3 = (String)cIMProperty.getValue().getValue();
                cIMObjectPath = new CIMObjectPath("IBMHSC_PCISlot", cIMInstance.getKeyValuePairs());
                enumeration = HscUtil.getCIMAssociationInst(this.mHostName, cIMObjectPath, "IBMHSC_AllocatedSlot", "IBMHSC_Partition", "PartComponent", "GroupComponent", true, false, null);
                if (enumeration.hasMoreElements()) {
                    cIMInstance = (CIMInstance)enumeration.nextElement();
                    if (null != cIMInstance) {
                        cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_INT);
                        string2 = (String)cIMProperty.getValue().getValue();
                        hashtable.put("partitionName", string2);
                        cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_USER);
                        String string5 = (String)cIMProperty.getValue().getValue();
                        hashtable.put("assignedTo", string5);
                    }
                    hashtable.put("Available", new Integer(1));
                } else {
                    hashtable.put("Available", new Integer(0));
                }
                hashtable.put(MOF_IO_DRAWER_DEVICE_ID, string);
                hashtable.put(MOF_SLOT_ID, new Short(s));
                hashtable.put(MOF_CLASS_CODE_INFO, string4);
                hashtable.put("SlotLocation", string3);
                vector.add(hashtable);
                ++n;
            }
            return vector;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Hashtable getSlotData(CIMInstance cIMInstance, TreeMap treeMap, boolean bl) {
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty(MOF_DRC_INDEX).getValue().getValue();
        String string = (String)cIMInstance.getProperty(MOF_CLASS_CODE_INFO).getValue().getValue();
        if (unsignedInt32.intValue() == 0 && !bl) {
            return null;
        }
        String string2 = (String)cIMInstance.getProperty(MOF_IO_DRAWER_DEVICE_ID).getValue().getValue();
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMInstance.getProperty(MOF_SLOT_ID).getValue().getValue();
        String string3 = (String)cIMInstance.getProperty("SlotLocation").getValue().getValue();
        UnsignedInt8 unsignedInt82 = (UnsignedInt8)cIMInstance.getProperty(MOF_PCI_BUS).getValue().getValue();
        String string4 = string3 + KEY_SEP + string;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(MOF_IO_DRAWER_DEVICE_ID, string2);
        hashtable.put(MOF_PCI_BUS, new Short(unsignedInt82.shortValue()));
        hashtable.put(MOF_SLOT_ID, new Short(unsignedInt8.shortValue()));
        hashtable.put("SlotLocation", string3);
        hashtable.put(MOF_CLASS_CODE_INFO, string);
        hashtable.put(MOF_DRC_INDEX, new Integer(unsignedInt32.intValue()));
        if (treeMap != null) {
            treeMap.put(string4, hashtable);
        }
        return hashtable;
    }

    public Vector getRecoverIOData() throws HSCException {
        try {
            CIMInstance cIMInstance = null;
            CIMObjectPath cIMObjectPath = null;
            CIMProperty cIMProperty = null;
            CIMValue cIMValue = null;
            Enumeration enumeration = this.getPartitionObjectPathes();
            Enumeration enumeration2 = null;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            Vector<Hashtable<String, Object>> vector = new Vector<Hashtable<String, Object>>();
            short s = 0;
            short s2 = 0;
            while (enumeration.hasMoreElements()) {
                cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_NAMES_INT);
                string2 = (String)cIMValue.getValue();
                cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_NAMES_USER);
                string6 = (String)cIMValue.getValue();
                cIMValue = HscUtil.getCIMAttribute(this.mHostName, cIMObjectPath, MOF_PARTITION_STATE);
                string5 = (String)cIMValue.getValue();
                if (!string5.equals(MOF_RUNNING_STATE)) continue;
                enumeration2 = HscUtil.getCIMAssociationInst(this.mHostName, cIMObjectPath, "IBMHSC_AllocatedSlot", "IBMHSC_PCISlot", "GroupComponent", "PartComponent", true, false, null);
                while (enumeration2.hasMoreElements()) {
                    UnsignedInt32 unsignedInt32;
                    cIMInstance = (CIMInstance)enumeration2.nextElement();
                    if (null == cIMInstance || (s2 = ((UnsignedInt8)(cIMProperty = cIMInstance.getProperty(MOF_STATE)).getValue().getValue()).shortValue()) != Short.parseShort(MOF_STOPPED_STATE) || (unsignedInt32 = (UnsignedInt32)cIMInstance.getProperty(MOF_DRC_INDEX).getValue().getValue()).intValue() == 0) continue;
                    cIMProperty = cIMInstance.getProperty(MOF_IO_DRAWER_DEVICE_ID);
                    string = (String)cIMProperty.getValue().getValue();
                    cIMProperty = cIMInstance.getProperty(MOF_SLOT_ID);
                    s = ((UnsignedInt8)cIMProperty.getValue().getValue()).shortValue();
                    cIMProperty = cIMInstance.getProperty(MOF_CLASS_CODE_INFO);
                    string4 = (String)cIMProperty.getValue().getValue();
                    cIMProperty = cIMInstance.getProperty("SlotLocation");
                    string3 = (String)cIMProperty.getValue().getValue();
                    hashtable = new Hashtable();
                    hashtable.put("partitionNameInt", string2);
                    hashtable.put("partitionNameUser", string6);
                    hashtable.put(MOF_IO_DRAWER_DEVICE_ID, string);
                    hashtable.put(MOF_SLOT_ID, new Short(s));
                    hashtable.put(MOF_STATE, new Short(s2));
                    hashtable.put(MOF_CLASS_CODE_INFO, string4);
                    hashtable.put("SlotLocation", string3);
                    vector.add(hashtable);
                }
            }
            return vector;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public Vector getSNIResources() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        Hashtable<String, Object> hashtable = null;
        String string = null;
        String string2 = null;
        String string3 = "";
        String string4 = "";
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        Vector vector3 = null;
        Vector vector4 = new Vector(4);
        Vector vector5 = null;
        Vector vector6 = null;
        Vector vector7 = null;
        UnsignedInt32 unsignedInt32 = null;
        int n = 0;
        int n2 = 0;
        try {
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_SNI_PAIR_INFO, vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                vector3 = (Vector)((CIMValue)vector2.elementAt(0)).getValue();
                vector5 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
            }
            vector2.clear();
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_SNI_LOGICAL_ID, vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                vector6 = (Vector)((CIMValue)vector2.elementAt(0)).getValue();
                vector7 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
            } else {
                vector6 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
            }
            n = 0;
            while (n < vector3.size()) {
                hashtable = new Hashtable<String, Object>();
                string = (String)vector3.elementAt(n);
                unsignedInt32 = (UnsignedInt32)vector5.elementAt(n);
                string2 = unsignedInt32.toString();
                string3 = "";
                string4 = "";
                n2 = vector6.indexOf(unsignedInt32);
                if (n2 != -1) {
                    string3 = string3 + Integer.toHexString(((UnsignedInt32)vector7.elementAt(n2)).intValue() >> 16);
                }
                cIMObjectPath = new CIMObjectPath("IBMHSC_SNIAdapter");
                cIMObjectPath.addKey(MOF_CPU_ID, new CIMValue((Object)unsignedInt32.toString()));
                cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                cIMObjectPath.addKey("SystemName", HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_PARTITION_NAMES_INT));
                cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_SNIAdapter"));
                cIMInstance = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath, false);
                string4 = string4 + cIMInstance.getProperty(MOF_SMA_PHY_LOC_CODE).getValue().getValue();
                while (n < vector3.size() - 1 && string.equals((String)vector3.elementAt(n + 1))) {
                    unsignedInt32 = (UnsignedInt32)vector5.elementAt(++n);
                    string2 = string2 + "/" + unsignedInt32;
                    n2 = vector6.indexOf(unsignedInt32);
                    if (n2 != -1) {
                        string3 = string3 + "/" + Integer.toHexString(((UnsignedInt32)vector7.elementAt(n2)).intValue() >> 16);
                    }
                    cIMObjectPath = new CIMObjectPath("IBMHSC_SNIAdapter");
                    cIMObjectPath.addKey(MOF_CPU_ID, new CIMValue((Object)unsignedInt32.toString()));
                    cIMObjectPath.addKey("SystemCreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
                    cIMObjectPath.addKey("SystemName", HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_PARTITION_NAMES_INT));
                    cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_SNIAdapter"));
                    cIMInstance = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath, false);
                    string4 = string4 + " / " + cIMInstance.getProperty(MOF_SMA_PHY_LOC_CODE).getValue().getValue();
                }
                hashtable.put(MOF_CPU_ID, string2);
                hashtable.put(MOF_SMA_NETWORK_ID, string3);
                hashtable.put("AffinityLocCode", string);
                hashtable.put(MOF_SMA_PHY_LOC_CODE, string4);
                hashtable.put(MOF_SMA_WINDOW_NUM, new Short(((UnsignedInt16)cIMInstance.getProperty(MOF_SMA_WINDOW_NUM).getValue().getValue()).shortValue()));
                vector4.add(hashtable);
                ++n;
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return vector4;
    }

    public boolean isSNICapable() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        short s = 0;
        try {
            cIMInstance = HscUtil.getCIMInstance(this.mHostName, this.mObjectPath, false);
            cIMProperty = cIMInstance.getProperty(MOF_RUNTIME_CAPABILITY);
            s = ((UnsignedInt8)cIMProperty.getValue().getValue()).shortValue();
            return (s & 0x20) != 0;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Vector getAllProcessorData() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath = null;
        CIMProperty cIMProperty = null;
        Enumeration enumeration = null;
        Hashtable<String, Object> hashtable = null;
        String string = null;
        Vector vector = null;
        short s = 0;
        short s2 = 0;
        try {
            vector = new Vector();
            Enumeration enumeration2 = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_CompSysProcessor", "IBMHSC_Processor", "GroupComponent", "PartComponent");
            while (enumeration2.hasMoreElements()) {
                hashtable = new Hashtable<String, Object>();
                cIMObjectPath = (CIMObjectPath)enumeration2.nextElement();
                cIMInstance = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath, false);
                cIMProperty = cIMInstance.getProperty(MOF_CPU_ID);
                s = ((UnsignedInt8)cIMProperty.getValue().getValue()).shortValue();
                cIMProperty = cIMInstance.getProperty(MOF_CPU_STATUS);
                s2 = ((UnsignedInt8)cIMProperty.getValue().getValue()).shortValue();
                enumeration = HscUtil.getCIMAssociationInst(this.mHostName, cIMObjectPath, "IBMHSC_AllocatedProcessor", "IBMHSC_Partition", "PartComponent", "GroupComponent", true, false, null);
                if (enumeration.hasMoreElements() && null != (cIMInstance = (CIMInstance)enumeration.nextElement())) {
                    cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_INT);
                    string = (String)cIMProperty.getValue().getValue();
                    hashtable.put("partitionName", string);
                    cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_USER);
                    String string2 = (String)cIMProperty.getValue().getValue();
                    hashtable.put("assignedTo", string2);
                }
                hashtable.put("cpuId", new Short(s));
                hashtable.put("cpuStatus", new Short(s2));
                vector.add(hashtable);
            }
            return vector;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Hashtable getProcessorData(String string) throws HSCException {
        try {
            Vector vector = this.getInputVector(string);
            Vector vector2 = new Vector();
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_DLPAR_CPU_INFO, vector, vector2);
            Vector vector3 = null;
            Vector vector4 = null;
            Vector vector5 = null;
            Vector vector6 = null;
            Vector vector7 = null;
            Vector vector8 = null;
            Vector vector9 = null;
            Vector vector10 = null;
            String string2 = null;
            if (vector2.elementAt(0) instanceof CIMValue) {
                vector3 = (Vector)((CIMValue)vector2.elementAt(0)).getValue();
                vector5 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
                vector4 = (Vector)((CIMValue)vector2.elementAt(2)).getValue();
                vector6 = (Vector)((CIMValue)vector2.elementAt(3)).getValue();
                vector7 = (Vector)((CIMValue)vector2.elementAt(4)).getValue();
                vector8 = (Vector)((CIMValue)vector2.elementAt(5)).getValue();
                vector9 = (Vector)((CIMValue)vector2.elementAt(6)).getValue();
                vector10 = (Vector)((CIMValue)vector2.elementAt(7)).getValue();
                string2 = (String)((CIMValue)vector2.elementAt(8)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector2.elementAt(4)).getValue().getValue();
                vector8 = (Vector)((CIMProperty)vector2.elementAt(5)).getValue().getValue();
                vector9 = (Vector)((CIMProperty)vector2.elementAt(6)).getValue().getValue();
                vector10 = (Vector)((CIMProperty)vector2.elementAt(7)).getValue().getValue();
                string2 = (String)((CIMProperty)vector2.elementAt(8)).getValue().getValue();
            }
            Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
            hashtable.put("freeCpus", this.getShortFromVector(vector3, 0));
            hashtable.put("stoppedCpuIds", vector6);
            hashtable.put("stoppedCpuStates", vector7);
            hashtable.put("stoppedCpuStatus", vector8);
            hashtable.put("stoppedCpuPartitionsInt", vector9);
            hashtable.put("stoppedCpuPartitionsUser", vector10);
            this.processMask(string2, vector3, vector4, vector5, hashtable, string, true);
            return hashtable;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public Hashtable getRecoverProcessorData() throws HSCException {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_DLPAR_CPU_INFO, vector, vector2);
            Vector vector3 = null;
            Vector vector4 = null;
            Vector vector5 = null;
            Vector vector6 = null;
            Vector vector7 = null;
            if (vector2.elementAt(0) instanceof CIMValue) {
                vector3 = (Vector)((CIMValue)vector2.elementAt(3)).getValue();
                vector4 = (Vector)((CIMValue)vector2.elementAt(4)).getValue();
                vector5 = (Vector)((CIMValue)vector2.elementAt(5)).getValue();
                vector6 = (Vector)((CIMValue)vector2.elementAt(6)).getValue();
                vector7 = (Vector)((CIMValue)vector2.elementAt(7)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector2.elementAt(4)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector2.elementAt(5)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector2.elementAt(6)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector2.elementAt(7)).getValue().getValue();
            }
            vector3 = this.convertUInt8ToShortVector(vector3);
            vector4 = this.convertUInt8ToShortVector(vector4);
            vector5 = this.convertUInt8ToShortVector(vector5);
            Hashtable<String, Vector> hashtable = new Hashtable<String, Vector>();
            hashtable.put("stoppedCpuIds", vector3);
            hashtable.put("stoppedCpuStates", vector4);
            hashtable.put("stoppedCpuStatus", vector5);
            hashtable.put("stoppedCpuPartitionsInt", vector6);
            hashtable.put("stoppedCpuPartitionsUser", vector7);
            return hashtable;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public Vector getAllMemoryData() throws HSCException {
        CIMInstance cIMInstance = null;
        Object var2_2 = null;
        CIMProperty cIMProperty = null;
        Object var4_4 = null;
        Hashtable<String, Object> hashtable = null;
        String string = null;
        Vector vector = null;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        try {
            vector = new Vector();
            Enumeration enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_CompSysPartition", "IBMHSC_Partition", "GroupComponent", "PartComponent", true, false, null);
            while (enumeration.hasMoreElements()) {
                hashtable = new Hashtable<String, Object>();
                cIMInstance = (CIMInstance)enumeration.nextElement();
                cIMProperty = cIMInstance.getProperty(MOF_PARTITION_STATE);
                if (null != cIMProperty.getValue() && null != cIMProperty.getValue().getValue()) {
                    n = ((UnsignedInt8)cIMProperty.getValue().getValue()).intValue();
                }
                if (n != 8) continue;
                cIMProperty = cIMInstance.getProperty(MOF_ALLOCATED_MEMORY);
                if (null != cIMProperty.getValue() && null != cIMProperty.getValue().getValue()) {
                    l = ((UnsignedInt32)cIMProperty.getValue().getValue()).longValue();
                }
                if (null != (cIMProperty = cIMInstance.getProperty(MOF_PAGE_TABLE_MEMORY)).getValue() && null != cIMProperty.getValue().getValue()) {
                    l2 = ((UnsignedInt32)cIMProperty.getValue().getValue()).longValue();
                }
                cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_INT);
                string = (String)cIMProperty.getValue().getValue();
                hashtable.put("allocatedMemory", new Long(l));
                hashtable.put("pageTableMemory", new Long(l2));
                hashtable.put("partitionName", string);
                cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_USER);
                String string2 = (String)cIMProperty.getValue().getValue();
                hashtable.put("assignedTo", string2);
                vector.add(hashtable);
            }
            return vector;
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
    }

    public Hashtable getMemoryData(String string) throws HSCException {
        try {
            Vector vector = this.getInputVector(string);
            Vector vector2 = new Vector();
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_DLPAR_MEM_INFO, vector, vector2);
            Vector vector3 = null;
            Vector vector4 = null;
            Vector vector5 = null;
            Vector vector6 = null;
            String string2 = null;
            if (vector2.elementAt(0) instanceof CIMValue) {
                vector3 = (Vector)((CIMValue)vector2.elementAt(0)).getValue();
                vector6 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
                vector5 = (Vector)((CIMValue)vector2.elementAt(2)).getValue();
                vector4 = (Vector)((CIMValue)vector2.elementAt(3)).getValue();
                string2 = (String)((CIMValue)vector2.elementAt(6)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                string2 = (String)((CIMProperty)vector2.elementAt(6)).getValue().getValue();
            }
            Hashtable<String, Serializable> hashtable = new Hashtable<String, Serializable>();
            hashtable.put("freeMems", this.getIntFromVector(vector3, 0));
            hashtable.put(MOF_LMB_SIZE, new Integer(this.getLMBSize()));
            hashtable.put("reqMems", vector6);
            this.processMask(string2, vector3, vector4, vector5, hashtable, string, false);
            return hashtable;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public Vector getRecoverMemoryData() throws HSCException {
        try {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_DLPAR_MEM_INFO, vector, vector2);
            Vector vector3 = null;
            Vector vector4 = null;
            Vector vector5 = null;
            Vector vector6 = null;
            String string = null;
            Vector vector7 = null;
            Vector vector8 = null;
            if (vector2.elementAt(0) instanceof CIMValue) {
                vector3 = (Vector)((CIMValue)vector2.elementAt(0)).getValue();
                vector6 = (Vector)((CIMValue)vector2.elementAt(1)).getValue();
                vector5 = (Vector)((CIMValue)vector2.elementAt(2)).getValue();
                vector4 = (Vector)((CIMValue)vector2.elementAt(3)).getValue();
                vector7 = (Vector)((CIMValue)vector2.elementAt(4)).getValue();
                vector8 = (Vector)((CIMValue)vector2.elementAt(5)).getValue();
                string = (String)((CIMValue)vector2.elementAt(6)).getValue();
            } else {
                vector3 = (Vector)((CIMProperty)vector2.elementAt(0)).getValue().getValue();
                vector6 = (Vector)((CIMProperty)vector2.elementAt(1)).getValue().getValue();
                vector5 = (Vector)((CIMProperty)vector2.elementAt(2)).getValue().getValue();
                vector4 = (Vector)((CIMProperty)vector2.elementAt(3)).getValue().getValue();
                vector7 = (Vector)((CIMProperty)vector2.elementAt(4)).getValue().getValue();
                vector8 = (Vector)((CIMProperty)vector2.elementAt(5)).getValue().getValue();
                string = (String)((CIMProperty)vector2.elementAt(6)).getValue().getValue();
            }
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            Vector<Hashtable<String, Object>> vector9 = new Vector<Hashtable<String, Object>>();
            UnsignedInt32 unsignedInt32 = null;
            UnsignedInt32 unsignedInt322 = null;
            UnsignedInt32 unsignedInt323 = null;
            UnsignedInt32 unsignedInt324 = null;
            String string2 = null;
            String string3 = null;
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            while (n3 < vector3.size()) {
                unsignedInt32 = (UnsignedInt32)vector3.elementAt(n3);
                unsignedInt322 = (UnsignedInt32)vector6.elementAt(n3);
                unsignedInt323 = (UnsignedInt32)vector4.elementAt(n3);
                unsignedInt324 = (UnsignedInt32)vector5.elementAt(n3);
                string2 = (String)vector7.elementAt(n3);
                string3 = (String)vector8.elementAt(n3);
                n = unsignedInt32.intValue();
                if (n != (n2 = unsignedInt322.intValue())) {
                    hashtable = new Hashtable();
                    hashtable.put("allocatedMemory", new Integer(unsignedInt32.intValue()));
                    hashtable.put("lmbSize", new Integer(this.getLMBSize()));
                    hashtable.put("requestedMrmoey", new Integer(unsignedInt322.intValue()));
                    hashtable.put("maxMemory", new Integer(unsignedInt323.intValue()));
                    hashtable.put("minMemory", new Integer(unsignedInt324.intValue()));
                    hashtable.put("partitionNameInt", string2);
                    hashtable.put("partitionNameUser", string3);
                    vector9.add(hashtable);
                }
                ++n3;
            }
            return vector9;
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public short getPartitionSlotId(String string) {
        String string2 = null;
        string2 = string.substring(0, string.indexOf(PARTITION_NAME_SEP));
        return Short.parseShort(string2);
    }

    public int getLMBSize() throws CIMException {
        if (this.mInst == null) {
            CIMValue cIMValue = HscUtil.getCIMAttribute(this.mHostName, this.mObjectPath, MOF_LMB_SIZE);
            Object object = cIMValue.getValue();
            return Integer.parseInt((String)object);
        }
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)this.mInst.getProperty(MOF_LMB_SIZE).getValue().getValue();
        return unsignedInt32.intValue();
    }

    public Vector getPartitionClients() throws HSCException {
        Enumeration enumeration;
        block4: {
            enumeration = null;
            try {
                enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_CompSysPartition", "IBMHSC_Partition", null, null, true, false, null);
            }
            catch (CIMException cIMException) {
                HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
                if (!IDebug.enabled) break block4;
                cIMException.printStackTrace();
            }
        }
        if (enumeration != null) {
            HSCClientObjectFactory hSCClientObjectFactory = HSCClientObjectFactory.getInstance(this.mHostName, null);
            CIMInstance cIMInstance = null;
            HSCLPARClient hSCLPARClient = null;
            String string = null;
            Vector<HSCLPARClient> vector = new Vector<HSCLPARClient>();
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                string = (String)cIMInstance.getProperty(MOF_PARTITION_NAMES_USER).getValue().getValue();
                hSCLPARClient = hSCClientObjectFactory.createLPARClient(this.getIntName(), string, false);
                vector.addElement(hSCLPARClient);
            }
            return vector;
        }
        return null;
    }

    public void recoverCPUResources(Vector vector) throws HSCException {
        int n;
        CIMValue cIMValue = null;
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector vector3 = new Vector();
        Vector<UnsignedInt8> vector4 = new Vector<UnsignedInt8>();
        Short s = null;
        String string = null;
        UnsignedInt8 unsignedInt8 = null;
        try {
            n = 0;
            while (n < vector.size()) {
                s = (Short)vector.elementAt(n);
                unsignedInt8 = new UnsignedInt8(s.shortValue());
                vector4.add(unsignedInt8);
                ++n;
            }
            cIMValue = new CIMValue(vector4, new CIMDataType(21));
            vector2.addElement(new CIMProperty(MOF_PROCESSOR_IDS, cIMValue));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_CPU_RECOVER, vector2, vector3);
        }
        catch (HSCCIMException hSCCIMException) {
            HSCLogUtils.clientLog((Throwable)((Object)hSCCIMException), HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                hSCCIMException.printStackTrace();
            }
            throw new HSCException((Throwable)((Object)hSCCIMException));
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
        n = ((UnsignedInt8)((CIMProperty)vector3.elementAt(0)).getValue().getValue()).shortValue();
        if (vector.size() != n) {
            string = "An error occurred while trying to restore stopped processors. There were {0} processors restored before the error occurred.";
            throw new HSCException(HSCResourceBundleUtil.getMessage("DLPARBundle", "RECOVER_CPU_ERR", string, new String[]{"" + n}));
        }
    }

    public void recoverMemResources(Vector vector) throws HSCException {
        CIMValue cIMValue = null;
        String string = null;
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        Vector vector3 = new Vector();
        try {
            cIMValue = new CIMValue(vector, new CIMDataType(29));
            vector2.addElement(new CIMProperty(MOF_PARTITION_NAMES, cIMValue));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_MEM_RECOVER, vector2, vector3);
        }
        catch (HSCCIMException hSCCIMException) {
            HSCLogUtils.clientLog((Throwable)((Object)hSCCIMException), HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                hSCCIMException.printStackTrace();
            }
            throw new HSCException((Throwable)((Object)hSCCIMException));
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
        Vector vector4 = (Vector)((CIMProperty)vector3.elementAt(0)).getValue().getValue();
        int n = vector4.size();
        if (vector.size() != n) {
            string = "An error occurred while trying to correct the requested memory value. There were {0} partitions that were corrected.";
            throw new HSCException(HSCResourceBundleUtil.getMessage("DLPARBundle", "RECOVER_MEM_ERR", string, new String[]{"" + n}));
        }
    }

    public void recoverIOResources(Vector vector, Vector vector2) throws HSCException {
        int n;
        CIMValue cIMValue = null;
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        Vector<UnsignedInt8> vector5 = new Vector<UnsignedInt8>();
        Short s = null;
        String string = null;
        UnsignedInt8 unsignedInt8 = null;
        try {
            n = 0;
            while (n < vector2.size()) {
                s = (Short)vector2.elementAt(n);
                unsignedInt8 = new UnsignedInt8(s.shortValue());
                vector5.add(unsignedInt8);
                ++n;
            }
            cIMValue = new CIMValue(vector, new CIMDataType(29));
            vector3.addElement(new CIMProperty(MOF_DRAWER_IDS, cIMValue));
            cIMValue = new CIMValue(vector5, new CIMDataType(21));
            vector3.addElement(new CIMProperty(MOF_SLOT_IDS, cIMValue));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_IO_RECOVER, vector3, vector4);
        }
        catch (HSCCIMException hSCCIMException) {
            HSCLogUtils.clientLog((Throwable)((Object)hSCCIMException), HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                hSCCIMException.printStackTrace();
            }
            throw new HSCException((Throwable)((Object)hSCCIMException));
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
        n = ((UnsignedInt8)((CIMProperty)vector4.elementAt(0)).getValue().getValue()).shortValue();
        if (vector2.size() != n) {
            string = "An error occurred while trying to restore stopped I/O devices. There were {0} devices restored before the error occurred.";
            throw new HSCException(HSCResourceBundleUtil.getMessage("DLPARBundle", "RECOVER_SLOT_ERR", string, new String[]{"" + n}));
        }
    }

    public boolean isSystemAttentionSupported() throws HSCException {
        return this.isLEDTypeSupported("1");
    }

    public boolean isIdentifySupported() throws HSCException {
        return this.isLEDTypeSupported(IDENTIFY_LED);
    }

    public Hashtable getSystemAttentionList() throws HSCException {
        return this.getLEDTypeList("1");
    }

    public Hashtable getIdentifyList() throws HSCException {
        return this.getLEDTypeList(IDENTIFY_LED);
    }

    public void setSystemAttentionState(Vector vector, Vector vector2) throws HSCException {
        this.setLED("1", vector, vector2);
    }

    public void setIdentifyState(Vector vector, Vector vector2) throws HSCException {
        this.setLED(IDENTIFY_LED, vector, vector2);
    }

    public short getSystemAttentionState(long l) throws HSCException {
        return this.getLEDState("1", l);
    }

    public short getIdentifyState(long l) throws HSCException {
        return this.getLEDState(IDENTIFY_LED, l);
    }

    public String doVTerm(short s) throws HSCException {
        CIMObjectPath cIMObjectPath = null;
        CIMProperty cIMProperty = null;
        CIMProperty cIMProperty2 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>(2);
        Vector vector2 = new Vector();
        int n = 0;
        try {
            cIMProperty = new CIMProperty("Request", new CIMValue((Object)new UnsignedInt8(s)));
            cIMProperty2 = new CIMProperty("Session_Number", new CIMValue((Object)new UnsignedInt8(0)));
            vector.add(cIMProperty);
            vector.add(cIMProperty2);
            string = this.getHostName();
            string2 = this.getIntName();
            cIMObjectPath = this.getObjectPath();
            n = Integer.parseInt((String)HscUtil.invokeCIMMethod(string, cIMObjectPath, "VirtualTTYRequest", vector, vector2).getValue());
            if (s == 1) {
                string3 = new String("_VT_ " + string + " " + "9734" + " " + "000*" + string2 + " " + n + " " + string2 + " _VT_");
            }
        }
        catch (Exception exception) {
            HSCLogUtils.clientLog(exception, HSCLogUtils._DLPARClassLogInfo);
            throw new HSCException("An error occurred when trying to open a virtual terminal.");
        }
        return string3;
    }

    public void removeSPLock() throws HSCException {
        CIMObjectPath cIMObjectPath = null;
        String string = null;
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        try {
            string = this.getHostName();
            cIMObjectPath = this.getObjectPath();
            HscUtil.invokeCIMMethod(string, cIMObjectPath, "ReleaseLockOwner", vector, vector2);
        }
        catch (CIMException cIMException) {
            HSCLogUtils.clientLog(cIMException, HSCLogUtils._DLPARClassLogInfo);
            if (IDebug.enabled()) {
                cIMException.printStackTrace();
            }
            throw new HSCException(cIMException);
        }
    }

    public Hashtable getLparNames() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        Object var3_3 = null;
        Enumeration enumeration = null;
        Hashtable hashtable = new Hashtable();
        String string = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        try {
            enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_CompSysPartition", "IBMHSC_Partition", "GroupComponent", "PartComponent", true, false, null);
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_INT);
                string = (String)cIMProperty.getValue().getValue();
                cIMProperty = cIMInstance.getProperty("PartitionType");
                n = ((UnsignedInt8)cIMProperty.getValue().getValue()).intValue();
                if (null == string) continue;
                if (0 == n || 1 == n) {
                    vector2.add(string);
                    continue;
                }
                if (2 != n && 3 != n) continue;
                vector.add(string);
            }
            hashtable.put("LparName", vector2);
            hashtable.put("AlparName", vector);
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return hashtable;
    }

    public Vector getSystemProfileNames() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMProperty cIMProperty = null;
        Object var3_3 = null;
        Enumeration enumeration = null;
        String string = null;
        Vector<String> vector = new Vector<String>();
        try {
            enumeration = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_CompSysProfile", "IBMHSC_SystemProfile", "Element", "Configuration", true, false, null);
            while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_INT);
                string = (String)cIMProperty.getValue().getValue();
                if (null == string) continue;
                vector.add(string);
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return vector;
    }

    public CuodActions getCuodActionHandler() {
        if (null == this.cuodActionHandler) {
            this.cuodActionHandler = CuodActions.getCuodInstance(this);
        }
        return this.cuodActionHandler;
    }

    public Vector getPPARInfo(String string, boolean bl) throws HSCException {
        CIMValue cIMValue = null;
        CIMProperty cIMProperty = null;
        Object var5_5 = null;
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        Vector vector2 = new Vector(3);
        Vector vector3 = null;
        try {
            vector.addElement(new CIMProperty("clusterSize", new CIMValue((Object)new UnsignedInt8(string))));
            vector.addElement(new CIMProperty("UpdateFlag", new CIMValue((Object)new UnsignedInt8(0))));
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "GetPPARSetupInfo", vector, vector2);
            if (vector2.elementAt(0) instanceof CIMValue) {
                cIMValue = (CIMValue)vector2.elementAt(0);
                vector3 = (Vector)cIMValue.getValue();
            } else {
                cIMProperty = (CIMProperty)vector2.elementAt(0);
                vector3 = (Vector)cIMProperty.getValue().getValue();
            }
            if (!bl) {
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, "RemoveReserved", new Vector(), new Vector());
            }
        }
        catch (CIMException cIMException) {
            throw new HSCException(cIMException);
        }
        return vector3;
    }

    public Hashtable getParentsOfCec() {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        try {
            Enumeration enumeration = HscUtil.getCIMAssociation(this.mHostName, this.mObjectPath, "IBMHSC_FrameCompSys", "IBMHSC_Frame", null, null);
            if (enumeration != null) {
                HSCClientObjectFactory hSCClientObjectFactory = HSCClientObjectFactory.getInstance(this.mHostName, null);
                while (enumeration.hasMoreElements()) {
                    CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                    CIMInstance cIMInstance = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath, false);
                    CIMProperty cIMProperty = cIMInstance.getProperty(MOF_PARTITION_NAMES_INT);
                    String string = (String)cIMProperty.getValue().getValue();
                    HSCFrameClient hSCFrameClient = hSCClientObjectFactory.createFrameClient(this.mHostName, string);
                    Hashtable hashtable2 = hSCFrameClient.getFrameAttributes(string);
                    hashtable.put(string, hashtable2);
                }
            }
        }
        catch (Exception exception) {
            return null;
        }
        return hashtable;
    }

    public Hashtable convertPhyLocsToSlotDrawerIds(List list) throws HSCException {
        CIMInstance cIMInstance = null;
        CIMValue cIMValue = null;
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        String string = null;
        UnsignedInt8 unsignedInt8 = null;
        Vector vector = null;
        String[] stringArray = new String[list.size()];
        String[] stringArray2 = new String[list.size()];
        int n = 0;
        vector = this.getAllSlotObjectInstances();
        int n2 = 0;
        while (n2 < vector.size()) {
            cIMInstance = (CIMInstance)vector.get(n2);
            cIMValue = cIMInstance.getProperty("SlotLocation").getValue();
            string = (String)cIMValue.getValue();
            int n3 = 0;
            while (n3 < list.size()) {
                if (string.equals((String)list.get(n3))) {
                    cIMValue = cIMInstance.getProperty(MOF_SLOT_ID).getValue();
                    unsignedInt8 = (UnsignedInt8)cIMValue.getValue();
                    stringArray2[n] = unsignedInt8.toString();
                    cIMValue = cIMInstance.getProperty(MOF_IO_DRAWER_DEVICE_ID).getValue();
                    stringArray[n] = string = (String)cIMValue.getValue();
                    ++n;
                    list.remove(n3);
                }
                ++n3;
            }
            if (list.size() == 0) break;
            ++n2;
        }
        if (list.size() != 0) {
            throw new HSCException("I/O device not found.");
        }
        hashtable.put("IODrawer", stringArray);
        hashtable.put("IOSlots", stringArray2);
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hashtable getSNIResourceUsage() throws HSCException {
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMInstance cIMInstance3 = null;
        CIMObjectPath cIMObjectPath = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMProperty cIMProperty = null;
        Enumeration enumeration = null;
        Hashtable hashtable = new Hashtable();
        Hashtable<String, Integer> hashtable2 = null;
        Integer n = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        Vector vector = null;
        String string4 = this.getIntName();
        try {
            Enumeration enumeration2 = HscUtil.getCIMAssociationInst(this.mHostName, this.mObjectPath, "IBMHSC_CompSysSNIAdapter", "IBMHSC_SNIAdapter", null, null, true, false, null);
            block2: while (true) {
                if (enumeration2 == null) return hashtable;
                if (!enumeration2.hasMoreElements()) {
                    return hashtable;
                }
                cIMInstance = (CIMInstance)enumeration2.nextElement();
                cIMObjectPath = new CIMObjectPath("IBMHSC_SNIAdapter", cIMInstance.getKeyValuePairs());
                string = (String)cIMInstance.getProperty(MOF_CPU_ID).getValue().getValue();
                enumeration = HscUtil.getCIMReferencesInst(this.mHostName, cIMObjectPath, "IBMHSC_AllocatedSNIAdapter", "PartComponent", false, false, null);
                vector = new Vector();
                while (true) {
                    if (enumeration == null || !enumeration.hasMoreElements()) {
                        hashtable.put(string, vector);
                        continue block2;
                    }
                    cIMInstance3 = (CIMInstance)enumeration.nextElement();
                    hashtable2 = new Hashtable<String, Integer>();
                    cIMProperty = cIMInstance3.getProperty("NumOfWindows");
                    n = null;
                    if (cIMProperty != null) {
                        n = new Integer(((Number)cIMProperty.getValue().getValue()).intValue());
                    }
                    if ((cIMProperty = cIMInstance3.getProperty("GroupComponent")) != null && n != null) {
                        cIMObjectPath2 = (CIMObjectPath)cIMProperty.getValue().getValue();
                        cIMInstance2 = HscUtil.getCIMInstance(this.mHostName, cIMObjectPath2, false);
                        UnsignedInt8 unsignedInt8 = (UnsignedInt8)cIMInstance2.getProperty(MOF_PARTITION_STATE).getValue().getValue();
                        String string5 = "" + unsignedInt8;
                        if (string5.equals(MOF_RUNNING_STATE)) {
                            string2 = (String)cIMInstance2.getProperty(MOF_PARTITION_NAMES_USER).getValue().getValue();
                            string3 = (String)cIMInstance2.getProperty(MOF_PARTITION_NAMES_INT).getValue().getValue();
                            if (string4.equalsIgnoreCase(string3.substring(4))) {
                                hashtable2.put(string2, n);
                            }
                        }
                    }
                    if (hashtable2.size() <= 0) continue;
                    vector.addElement(hashtable2);
                }
                break;
            }
        }
        catch (Throwable throwable) {
            HSCLogUtils.clientLog(throwable, HSCLogUtils._DLPARClassLogInfo);
            if (!IDebug.enabled()) return hashtable;
            throwable.printStackTrace(System.out);
            return hashtable;
        }
    }

    private boolean isLEDTypeSupported(String string) throws HSCException {
        int n = 0;
        try {
            Vector vector = this.getLEDInputVector(string);
            Vector vector2 = new Vector();
            HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_SUPPORTED_LED, vector, vector2);
            CIMProperty cIMProperty = (CIMProperty)vector2.elementAt(0);
            n = ((UnsignedInt16)cIMProperty.getValue().getValue()).intValue();
        }
        catch (Exception exception) {
            throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), exception);
        }
        return n == 1;
    }

    private Hashtable getLEDTypeList(String string) throws HSCException {
        Hashtable hashtable = null;
        String string2 = null;
        String string3 = null;
        Vector vector = null;
        Vector<Object> vector2 = null;
        Vector vector3 = null;
        Vector vector4 = null;
        short s = 0;
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            try {
                vector3 = this.getLEDInputVector(string);
                vector4 = new Vector();
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_LIST_LED, vector3, vector4);
                CIMProperty cIMProperty = (CIMProperty)vector4.elementAt(0);
                vector = (Vector)cIMProperty.getValue().getValue();
                int n3 = 0;
                if (vector == null) {
                    return null;
                }
                hashtable = new Hashtable();
                while (n3 < vector.size()) {
                    string3 = (String)vector.get(n3);
                    string2 = (String)vector.get(++n3);
                    ++n3;
                    s = this.getLEDState(string, Long.parseLong(string2));
                    vector2 = new Vector<Object>();
                    vector2.add(string3);
                    vector2.add(new Short(s));
                    hashtable.put(string2, vector2);
                }
                bl = !bl;
            }
            catch (CIMException cIMException) {
                if (n2 > 1) {
                    throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), cIMException);
                }
                n = cIMException.toString().indexOf(CSP_BUSY_EXCEPTION_ID);
                if (n != -1) {
                    try {
                        Thread.sleep(5000L);
                        ++n2;
                        continue;
                    }
                    catch (Exception exception) {
                        throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), exception);
                    }
                }
                HSCLogUtils.clientLog(cIMException, HSCLogUtils._LEDClassLogInfo);
                throw new HSCException(cIMException.getMessage());
            }
            catch (Exception exception) {
                throw new HSCException(exception);
            }
        }
        return hashtable;
    }

    private void setLED(String string, Vector vector, Vector vector2) throws HSCException {
        CIMValue cIMValue = null;
        Long l = null;
        Short s = null;
        String string2 = null;
        UnsignedInt32 unsignedInt32 = null;
        UnsignedInt16 unsignedInt16 = null;
        UnsignedInt8 unsignedInt8 = null;
        int n = -1;
        int n2 = 0;
        Vector<CIMProperty> vector3 = new Vector<CIMProperty>();
        Vector vector4 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            try {
                l = (Long)vector.elementAt(i);
                s = (Short)vector2.elementAt(i);
                unsignedInt8 = new UnsignedInt8(string);
                unsignedInt32 = new UnsignedInt32(l.longValue());
                unsignedInt16 = new UnsignedInt16((int)s.shortValue());
                cIMValue = new CIMValue((Object)unsignedInt8, new CIMDataType(1));
                vector3.addElement(new CIMProperty(MOF_LED_TYPE, cIMValue));
                cIMValue = new CIMValue((Object)unsignedInt32, new CIMDataType(5));
                vector3.addElement(new CIMProperty(MOF_INDEX_LED, cIMValue));
                cIMValue = new CIMValue((Object)unsignedInt16, new CIMDataType(3));
                vector3.addElement(new CIMProperty(MOF_SETTING_LED, cIMValue));
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_SET_LED, vector3, vector4);
                string2 = s.intValue() == 0 ? "off" : "on";
                String string3 = new String("LED: Finished setting LED state to " + string2);
                HSCLogUtils.logSystemEvent((short)2151, string3, new String[0], string2);
                n2 = 0;
                continue;
            }
            catch (CIMException cIMException) {
                if (n2 > 1) {
                    throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), cIMException);
                }
                n = cIMException.toString().indexOf(CSP_BUSY_EXCEPTION_ID);
                if (n != -1) {
                    try {
                        Thread.sleep(5000L);
                        ++n2;
                    }
                    catch (Exception exception) {
                        throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), exception);
                    }
                }
                if ((n = cIMException.toString().indexOf("3001")) != -1) {
                    HSCLogUtils.clientLog(cIMException, HSCLogUtils._LEDClassLogInfo);
                    throw new HSCException(cIMException.getMessage());
                }
                HSCLogUtils.clientLog(cIMException, HSCLogUtils._LEDClassLogInfo);
                throw new HSCException(cIMException.getMessage());
            }
            catch (Exception exception) {
                HSCLogUtils.clientLog(exception, HSCLogUtils._LEDClassLogInfo);
                throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), exception);
            }
        }
    }

    private short getLEDState(String string, long l) throws HSCException {
        CIMValue cIMValue = null;
        UnsignedInt32 unsignedInt32 = null;
        short s = 0;
        boolean bl = false;
        int n = -1;
        int n2 = 0;
        while (!bl) {
            try {
                Vector vector = this.getLEDInputVector(string);
                Vector vector2 = new Vector();
                unsignedInt32 = new UnsignedInt32(l);
                cIMValue = new CIMValue((Object)unsignedInt32, new CIMDataType(5));
                vector.addElement(new CIMProperty(MOF_INDEX_LED, cIMValue));
                HscUtil.invokeCIMMethod(this.mHostName, this.mObjectPath, MOF_GET_STATE_LED, vector, vector2);
                CIMProperty cIMProperty = (CIMProperty)vector2.elementAt(0);
                s = ((UnsignedInt16)cIMProperty.getValue().getValue()).shortValue();
                bl = !bl;
            }
            catch (CIMException cIMException) {
                if (n2 > 1) {
                    throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), cIMException);
                }
                n = cIMException.toString().indexOf(CSP_BUSY_EXCEPTION_ID);
                if (n != -1) {
                    try {
                        Thread.sleep(5000L);
                        ++n2;
                        continue;
                    }
                    catch (Exception exception) {
                        throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), exception);
                    }
                }
                HSCLogUtils.clientLog(cIMException, HSCLogUtils._LEDClassLogInfo);
                throw new HSCException(cIMException.getMessage());
            }
            catch (Exception exception) {
                throw new HSCException(HSCResourceBundleUtil.getMessage("CECBundle", "LED_CIM_ERROR"), exception);
            }
        }
        return s;
    }

    private void processMask(String string, Vector vector, Vector vector2, Vector vector3, Hashtable hashtable, String string2, boolean bl) throws HSCException {
        Hashtable hashtable2 = this.getMoveToParNames(string2, bl ? "cpu" : "mem");
        short s = this.getPartitionSlotId(string2);
        char[] cArray = string.toCharArray();
        Hashtable<Short, Integer> hashtable3 = new Hashtable<Short, Integer>();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != '0') {
                ++n;
                if (s == n2 + 1) {
                    hashtable.put(bl ? "allocCpus" : "allocMems", this.getValFromVector(vector, n, bl));
                    hashtable.put(bl ? "minCpus" : "minMems", this.getValFromVector(vector3, n, bl));
                    hashtable.put(bl ? "maxCpus" : "maxMems", this.getValFromVector(vector2, n, bl));
                } else {
                    hashtable3.put(new Short((short)(n2 + 1)), new Integer(n));
                }
            }
            ++n2;
        }
        if (hashtable2 == null) {
            return;
        }
        Vector vector4 = (Vector)hashtable2.get("parSlotIds");
        Vector vector5 = (Vector)hashtable2.get("intNames");
        Vector vector6 = (Vector)hashtable2.get("userNames");
        if (vector4 == null) {
            return;
        }
        Integer n3 = null;
        Vector<Object> vector7 = new Vector<Object>();
        Vector<Object> vector8 = new Vector<Object>();
        int n4 = 0;
        while (n4 < vector4.size()) {
            Short s2 = (Short)vector4.elementAt(n4);
            n3 = (Integer)hashtable3.get(s2);
            if (null == n3) {
                vector4.remove(n4);
                vector5.remove(n4);
                vector6.remove(n4);
                --n4;
            } else {
                n = n3;
                Object object = this.getValFromVector(vector2, n, bl);
                Object object2 = this.getValFromVector(vector, n, bl);
                if (object2.equals(object)) {
                    vector4.remove(n4);
                    vector5.remove(n4);
                    vector6.remove(n4);
                    --n4;
                } else {
                    vector7.addElement(this.getValFromVector(vector2, n, bl));
                    vector8.addElement(this.getValFromVector(vector, n, bl));
                }
            }
            ++n4;
        }
        hashtable2.put("maxNums", vector7);
        hashtable2.put("allocNums", vector8);
        hashtable.put("moveToPartitions", hashtable2);
    }

    private Object getValFromVector(Vector vector, int n, boolean bl) {
        if (bl) {
            return this.getShortFromVector(vector, n);
        }
        return this.getIntFromVector(vector, n);
    }

    private Short getShortFromVector(Vector vector, int n) {
        UnsignedInt8 unsignedInt8 = (UnsignedInt8)vector.elementAt(n);
        return new Short(unsignedInt8.shortValue());
    }

    private Integer getIntFromVector(Vector vector, int n) {
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)vector.elementAt(n);
        return new Integer(unsignedInt32.intValue());
    }

    private Vector getInputVector(String string) {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(this.getPartitionSlotId(string));
        CIMValue cIMValue = new CIMValue((Object)unsignedInt8, new CIMDataType(1));
        vector.addElement(new CIMProperty(MOF_LPAR_SLOT_ID, cIMValue));
        return vector;
    }

    private Vector convertUInt8ToShortVector(Vector vector) {
        UnsignedInt8 unsignedInt8 = null;
        Vector<Short> vector2 = new Vector<Short>();
        int n = 0;
        while (n < vector.size()) {
            unsignedInt8 = (UnsignedInt8)vector.elementAt(n);
            vector2.add(new Short(unsignedInt8.shortValue()));
            ++n;
        }
        return vector2;
    }

    private Vector getLEDInputVector(String string) {
        Vector<CIMProperty> vector = new Vector<CIMProperty>();
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(string);
        CIMValue cIMValue = new CIMValue((Object)unsignedInt8, new CIMDataType(1));
        vector.addElement(new CIMProperty(MOF_LED_TYPE, cIMValue));
        return vector;
    }

    private void createDefaultProfileAssociation(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) throws CIMException {
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMObjectPath cIMObjectPath4 = null;
        String string = null;
        string = this.getHostName();
        cIMObjectPath4 = new CIMObjectPath("IBMHSC_DefaultLparProfile");
        cIMClass = HscUtil.getCIMClass(string, cIMObjectPath4, false);
        cIMInstance = HscUtil.createNewCIMInstance(cIMClass);
        cIMInstance.setProperty("Element", new CIMValue((Object)cIMObjectPath2));
        cIMInstance.setProperty("Setting", new CIMValue((Object)cIMObjectPath));
        cIMObjectPath4 = new CIMObjectPath("IBMHSC_DefaultLparProfile", cIMInstance.getKeyValuePairs());
        cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
        cIMObjectPath3 = HscUtil.createCIMInstance(string, cIMObjectPath4, cIMInstance);
    }

    private void createSysProfileAssociations(String string, Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        CIMClass cIMClass = null;
        CIMInstance cIMInstance = null;
        CIMInstance cIMInstance2 = null;
        CIMObjectPath cIMObjectPath2 = null;
        CIMObjectPath cIMObjectPath3 = null;
        CIMObjectPath cIMObjectPath4 = null;
        Enumeration enumeration = null;
        short s = 0;
        enumeration = vector.elements();
        cIMObjectPath4 = new CIMObjectPath("IBMHSC_InSysProfile");
        cIMClass = HscUtil.getCIMClass(string, cIMObjectPath4, false);
        int n = 0;
        while (n < vector.size()) {
            cIMInstance = (CIMInstance)vector.elementAt(n);
            cIMObjectPath3 = new CIMObjectPath("IBMHSC_LparProfile", cIMInstance.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            cIMInstance2 = HscUtil.createNewCIMInstance(cIMClass);
            cIMInstance2.setProperty("Context", new CIMValue((Object)cIMObjectPath));
            cIMInstance2.setProperty("Setting", new CIMValue((Object)cIMObjectPath3));
            s = (short)n;
            cIMInstance2.setProperty("ActivateOrder", new CIMValue((Object)new UnsignedInt8(s)));
            cIMObjectPath4 = new CIMObjectPath("IBMHSC_InSysProfile", cIMInstance2.getKeyValuePairs());
            cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
            cIMObjectPath2 = HscUtil.createCIMInstance(string, cIMObjectPath4, cIMInstance2);
            ++n;
        }
    }

    private CIMInstance buildProfileInParams(CIMInstance cIMInstance, Hashtable hashtable) throws HSCException {
        int n;
        Object var3_3 = null;
        Hashtable hashtable2 = null;
        Integer n2 = null;
        List list = null;
        List list2 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        Short s = null;
        String string = null;
        String string2 = null;
        Object var13_13 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = null;
        Object var17_17 = null;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<UnsignedInt8> vector3 = new Vector<UnsignedInt8>();
        Vector vector4 = new Vector();
        long l = -1L;
        long l2 = -1L;
        long l3 = -1L;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        boolean bl2 = false;
        short s2 = -1;
        short s3 = -1;
        short s4 = -1;
        short s5 = -1;
        short s6 = -1;
        short s7 = -1;
        String[] stringArray = null;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = null;
        Short s8 = new Short(0);
        Integer[] integerArray = new Integer[]{};
        String[] stringArray5 = new String[]{};
        short s9 = 1;
        boolean bl3 = false;
        string = (String)hashtable.get("Action");
        string2 = (String)hashtable.get("PartitionName");
        string3 = (String)hashtable.get("ProfileName");
        n2 = (Integer)hashtable.get("DesiredCPUCount");
        if (n2 != null) {
            s2 = n2.shortValue();
        }
        if ((n2 = (Integer)hashtable.get("MinimumCPUCount")) != null) {
            s3 = n2.shortValue();
        }
        if ((n2 = (Integer)hashtable.get("MaximumCPUCount")) != null) {
            s4 = n2.shortValue();
        }
        if ((n2 = (Integer)hashtable.get("DesiredMemoryMB")) != null) {
            l = n2.longValue();
        }
        if ((n2 = (Integer)hashtable.get("MinimumMemoryMB")) != null) {
            l2 = n2.longValue();
        }
        if ((n2 = (Integer)hashtable.get("MaximumMemoryMB")) != null) {
            l3 = n2.longValue();
        }
        s = (Short)hashtable.get("ServiceAuthority");
        s7 = s;
        s = (Short)hashtable.get("RMOSize");
        s9 = s;
        if (IDebug.enabled) {
            System.out.println("The RMO Type is " + s9);
        }
        s = (Short)hashtable.get("SFPSurveillance");
        s6 = s;
        s = (Short)hashtable.get("BootMode");
        s5 = s;
        list = (List)hashtable.get("Desired_IO");
        list2 = (List)hashtable.get("Required_IO");
        if (list != null) {
            hashtable2 = this.convertPhyLocsToSlotDrawerIds(list);
            stringArray2 = (String[])hashtable2.get("IODrawer");
            stringArray4 = (String[])hashtable2.get("IOSlots");
        }
        if (list2 != null) {
            hashtable2 = this.convertPhyLocsToSlotDrawerIds(list2);
            stringArray = (String[])hashtable2.get("IODrawer");
            stringArray3 = (String[])hashtable2.get("IOSlots");
        }
        if (stringArray != null && stringArray3 != null) {
            n3 = stringArray.length;
        }
        if (stringArray2 != null && stringArray4 != null) {
            n4 = stringArray2.length;
        }
        int n5 = n3 + n4;
        int n6 = 0;
        while (n6 < n3) {
            vector.add(n6, stringArray[n6]);
            vector2.add(n6, "R");
            string4 = stringArray3[n6];
            stringTokenizer = new StringTokenizer(string4, "Slot_");
            n = Short.parseShort(stringTokenizer.nextToken());
            vector3.add(n6, new UnsignedInt8((short)n));
            ++n6;
        }
        n = n3;
        while (n < n5) {
            vector.add(n, stringArray2[n - n3]);
            vector2.add(n, "D");
            string4 = stringArray4[n - n3];
            stringTokenizer = new StringTokenizer(string4, "Slot_");
            short s10 = Short.parseShort(stringTokenizer.nextToken());
            vector3.add(n, new UnsignedInt8(s10));
            ++n;
        }
        s8 = (Short)hashtable.get("SNIConfigMode");
        var9_9 = hashtable.get("SNIDeviceID");
        if (var9_9 != null) {
            stringArray5 = var9_9;
        }
        if ((var9_9 = hashtable.get("SNIWindows")) != null) {
            integerArray = var9_9;
        }
        if (stringArray5 != null && integerArray != null) {
            StringTokenizer stringTokenizer2 = null;
            Vector<String> vector5 = new Vector<String>();
            Vector<Integer> vector6 = new Vector<Integer>();
            int n7 = 0;
            while (n7 < stringArray5.length) {
                stringTokenizer2 = new StringTokenizer(stringArray5[n7], "/");
                while (stringTokenizer2.hasMoreTokens()) {
                    vector5.addElement(stringTokenizer2.nextToken());
                    vector6.addElement(integerArray[n7]);
                }
                ++n7;
            }
            stringArray5 = vector5.toArray(stringArray5);
            integerArray = vector6.toArray(integerArray);
        }
        if (string.equals("createProfile")) {
            cIMInstance.setProperty("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMInstance.setProperty("PartitionName", new CIMValue((Object)string2));
            cIMInstance.setProperty("SettingID", new CIMValue((Object)"tempSID"));
        }
        cIMInstance.setProperty("DesiredCPUCount", new CIMValue((Object)new UnsignedInt8(s2)));
        cIMInstance.setProperty("MinimumCPUCount", new CIMValue((Object)new UnsignedInt8(s3)));
        cIMInstance.setProperty("MaximumCPUCount", new CIMValue((Object)new UnsignedInt8(s4)));
        cIMInstance.setProperty("DesiredMemoryMB", new CIMValue((Object)new UnsignedInt32(l)));
        cIMInstance.setProperty("MinimumMemoryMB", new CIMValue((Object)new UnsignedInt32(l2)));
        cIMInstance.setProperty("MaximumMemoryMB", new CIMValue((Object)new UnsignedInt32(l3)));
        if (vector == null || vector.size() == 0) {
            vector = new Vector();
        }
        cIMInstance.setProperty("IODrawer", new CIMValue(vector, new CIMDataType(29)));
        if (vector2 == null || vector2.size() == 0) {
            vector2 = new Vector();
        }
        cIMInstance.setProperty("IORequirement", new CIMValue(vector2, new CIMDataType(29)));
        if (vector3 == null || vector3.size() == 0) {
            vector3 = new Vector();
        }
        cIMInstance.setProperty("IOSlots", new CIMValue(vector3, new CIMDataType(21)));
        if (s8 != null) {
            cIMInstance.setProperty("SNIConfigMode", new CIMValue((Object)new UnsignedInt8(s8.shortValue()), new CIMDataType(1)));
        }
        if (stringArray5 != null) {
            cIMInstance.setProperty("SNIDeviceID", new CIMValue((Object)stringArray5, new CIMDataType(29)));
        }
        UnsignedInt16[] unsignedInt16Array = null;
        if (integerArray != null) {
            unsignedInt16Array = new UnsignedInt16[integerArray.length];
            int n8 = 0;
            while (n8 < integerArray.length) {
                unsignedInt16Array[n8] = new UnsignedInt16(integerArray[n8].intValue());
                ++n8;
            }
        }
        cIMInstance.setProperty("SNIWindows", new CIMValue((Object)unsignedInt16Array, new CIMDataType(23)));
        cIMInstance.setProperty("BootMode", new CIMValue((Object)new UnsignedInt8(s5)));
        cIMInstance.setProperty("ServiceAuthority", new CIMValue((Object)new UnsignedInt8(s7)));
        cIMInstance.setProperty("RMOSize", new CIMValue((Object)new UnsignedInt8(s9)));
        cIMInstance.setProperty("SFPSurveillance", new CIMValue((Object)new UnsignedInt8(s6)));
        cIMInstance.setProperty(MOF_PARTITION_NAMES_USER, new CIMValue((Object)string3));
        return cIMInstance;
    }
}

